import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import SvgColor from '@/shared/components/svg-color';
import { TableColumn } from '@/shared/types/common';
import TableActionColumn from '@/shared/components/table/table-action-column';
import { LotList } from '@/shared/types/infrastructure';
import { ContratStyledRow } from '@/shared/sections/contract/styles';
import { alpha } from '@mui/material';
import { useTheme } from '@mui/material/styles';
import { useInfrastructureStore } from '@/shared/api/stores/admin-service/infrastructureStore';
import dayjs from 'dayjs';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  handleEdit: (lot: LotList) => void;
  handleDetails: (lot: LotList) => void;
  handleCopy: (lot: LotList) => void;
  selected: boolean;
  row: LotList;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  handleOpenConsult: (lot: LotList) => void;
};

const TOOLTIP_TITLES = {
  active: 'Lot activé',
  inactive: 'Lot désactivé',
};

export default function LotTableRow({
  dense,
  row,
  handleEdit,
  handleDetails,
  handleCopy,
  selected,
  onSelectRow,
  columns,
  handleOpenConsult,
}: Props) {
  const theme = useTheme();

  const { toggleLotActivation } = useInfrastructureStore();

  const handleDoubleClick = () => {
    handleOpenConsult(row);
  };

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'createdAt':
        return dayjs(value).format('DD-MM-YYYY HH:mm');
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow
      hover
      style={{
        backgroundColor: selected
          ? alpha(theme.palette.primary.main, 0.1)
          : undefined,
        cursor: 'pointer',
      }}
    >
   
      {columns.map((column: any,index:number) => (
        <TableCell
          onDoubleClick={handleDoubleClick}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: 'nowrap', py: dense ? 0 : 2,
            ...(index === 0 && {
              position: 'relative',
            })
          }}
        >
          <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{
                position: 'absolute',
                top: 0,
                left: -4,
                height: '100%',
                color: theme.palette.primary.main,
              }}
            />
          </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof LotList])}
        </TableCell>
      ))}
      <TableCell sx={{ px: 1, whiteSpace: 'nowrap', py: 0 }}>
        <TableActionColumn
          handleEdit={() => handleEdit(row)}
          onToggle={(checked) => toggleLotActivation(row.id, checked)}
          isActive={row.active}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  );
}