import * as Yup from 'yup';

export const agencySchema = Yup.object().shape({
  name: Yup.string().required('Le nom de l\'agence est requis'),
  sector: Yup.array().min(1, 'Au moins un secteur doit être sélectionné'),
  adresse: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
  }),
  description: Yup.string(),
});

export const sectorSchema = Yup.object().shape({
  name: Yup.string().required('Le nom du secteur est requis'),
  adresse:  Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
  }),
  description: Yup.string(),
});

export const departmentSchema = Yup.object().shape({
  name: Yup.string().required('Le nom du département est requis'),
  agency: Yup.string().required('L\'agence est requise'),
  adresse: Yup.object().shape({
    address: Yup.string().required('L\'adresse est requise'),
    lat: Yup.number(),
    lng: Yup.number(),
  }),
  description: Yup.string(),
});

export const lotSchema = Yup.object().shape({
  department: Yup.array().min(1, 'Au moins un département doit être sélectionné'),
  lotNumber: Yup.string().required('Le numéro de lot est requis'),
  description: Yup.string(),
}); 