import React from 'react';
import { Box, Card, CardHeader, CircularProgress, Table, TableBody, TableCell, TableContainer, TableHead, TableRow, Typography } from '@mui/material';
import { ScheduleListPageable } from '@/shared/types/amendment';

interface AvenantSchedulesProps {
  schedules: ScheduleListPageable | null;
  loading: boolean;
}

export default function AvenantSchedules({ schedules, loading }: AvenantSchedulesProps) {
  if (loading) {
    return (
      <Box sx={{ display: 'flex', justifyContent: 'center', p: 3 }}>
        <CircularProgress />
      </Box>
    );
  }

  if (!schedules || !schedules.content || schedules.content.length === 0) {
    return (
      <Box sx={{ p: 3, textAlign: 'center' }}>
        <Typography variant="body1">Aucun horaire associé à cet avenant</Typography>
      </Box>
    );
  }

  return (
    <Card>
      <CardHeader title="Horaires associés" />
      <TableContainer>
        <Table>
          <TableHead>
            <TableRow>
              <TableCell>ID</TableCell>
              <TableCell>Trajet ID</TableCell>
              <TableCell>Jour</TableCell>
              <TableCell>Heure de départ</TableCell>
              <TableCell>Heure d&apos;arrivée</TableCell>
              <TableCell>Capacité</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {schedules.content.map((schedule) => (
              <TableRow key={schedule.id}>
                <TableCell>{schedule.id}</TableCell>
                <TableCell>{schedule.tripId}</TableCell>
                <TableCell>{schedule.day}</TableCell>
                <TableCell>{schedule.departureTime}</TableCell>
                <TableCell>{schedule.arrivalTime}</TableCell>
                <TableCell>{schedule.capacity}</TableCell>
              </TableRow>
            ))}
          </TableBody>
        </Table>
      </TableContainer>
    </Card>
  );
}
