import { _CIRCUIT_STATUS } from "@/shared/_mock/_circuit";
import { _BINARY_Qst } from "@/shared/_mock/_trajets";
import { IAvenant, ICircuit } from "@/shared/types/circuit";
import { FormFieldType } from "@/shared/types/common";
import { BinaryQuestion } from "@/shared/types/trajet";
import { faAddressCard, faEuro, faHashtag, faStickyNote, faTag } from "@fortawesome/free-solid-svg-icons";

export const mainAvenantformFields: FormFieldType<IAvenant>[] = [
    {
      name: 'codeAvenant',
      label: 'Code de l\'avenant',
      type: 'text',
      icon: faHashtag,
    },
    {
      name: 'intitule',
      label: 'Intitulé',
      type: 'text',
      icon: '/assets/icons/menu/ic_exploitation.svg',
      required: true,
    },
]
export const detailsAvenantformFields: FormFieldType<ICircuit>[] = [
    {
        name: 'etat',
        label: 'État du circuit',
        type: 'select',
        options: _CIRCUIT_STATUS,
      },
      {
        name: 'adresseEtablissement',
        label: 'Prise en charge',
        type: 'address',
        placeholder: 'Entrez une adresse',
      },
      {
        name: 'etablissement',
        label: 'Établissement principal',
        type: 'text',
        placeholder: 'Entrez un nom',
        required: true,
        icon: '/assets/icons/form/ic_building.svg',
      },
      {
        name: 'dateDebut',
        label: 'Date de début',
        type: 'date',
        required: true,
      },
      {
        name: 'typeCalcul',
        label: 'Type de calcul',
        type: 'select',
        options: [
          { value: 'calculAutomatique', label: 'Calcul Automatique' },
          { value: 'calculManuel', label: 'Calcul manuel' },
        ],
      },
      {
        name: 'dateFin',
        label: 'Date de fin',
        type: 'date',
        required: true,
      },
      {
        name: 'chauffeur',
        label: 'Chauffeurs',
        type: 'text',
        placeholder: 'Entrez un nom',
        icon: faAddressCard,
      },
      {
        name: 'grillePrix',
        label: 'Grille de prix',
        type: 'text',
        placeholder: '0',
        icon: faEuro,
      },

      {
        name: 'colorCode',
        label: 'Couleur de catégorisation',
        type: 'color',
        placeholder: 'Choisissez une couleur',
        required: true,
        icon: '/assets/icons/form/ic_palette.svg',
      },
      {
        name: 'observation',
        label: "Observation",
        placeholder:"Ajoutez une note ou une observation",
        type: 'textarea',
        icon: faStickyNote,
      },
    ];