'use client';

import React from 'react';
import { Box, CircularProgress, Grid, Stack, Typography } from '@mui/material';
import { useAvenantDetails } from '../hooks/use-avenant-details';
import AvenantTrips from '../components/avenant-trips';
import AvenantSchedules from '../components/avenant-schedules';

interface AvenantDetailViewProps {
  amendmentId: string;
}

export default function AvenantDetailView({ amendmentId }: AvenantDetailViewProps) {
  const { avenant, trips, schedules, loading, error } = useAvenantDetails(amendmentId);

  if (loading && !avenant) {
    return (
      <Box sx={{ display: 'flex', justifyContent: 'center', p: 5 }}>
        <CircularProgress />
      </Box>
    );
  }

  if (error) {
    return (
      <Box sx={{ p: 3, textAlign: 'center' }}>
        <Typography variant="body1" color="error">
          {error}
        </Typography>
      </Box>
    );
  }

  if (!avenant) {
    return (
      <Box sx={{ p: 3, textAlign: 'center' }}>
        <Typography variant="body1">Avenant non trouvé</Typography>
      </Box>
    );
  }

  return (
    <Box sx={{ p: 3 }}>
      <Typography variant="h4" sx={{ mb: 3 }}>
        Avenant: {avenant.intitule}
      </Typography>

      <Box sx={{ mb: 4 }}>
        <Grid container spacing={2}>
          <Grid item xs={12} md={6}>
            <Stack spacing={2}>
              <Typography variant="subtitle1">Code: {avenant.codeAvenant}</Typography>
              <Typography variant="subtitle1">Date d&#39;application: {avenant.dateApplication}</Typography>
              <Typography variant="subtitle1">État: {avenant.etat}</Typography>
              <Typography variant="subtitle1">Client: {avenant.clientDO}</Typography>
            </Stack>
          </Grid>
          <Grid item xs={12} md={6}>
            <Stack spacing={2}>
              <Typography variant="subtitle1">Chauffeur: {avenant.chauffeur}</Typography>
              <Typography variant="subtitle1">Société: {avenant.departement}</Typography>
              <Typography variant="subtitle1">Circuit: {avenant.codeCircuit}</Typography>
            </Stack>
          </Grid>
        </Grid>
      </Box>

      <Stack spacing={4}>
        <AvenantTrips trips={trips} loading={loading} />
        <AvenantSchedules schedules={schedules} loading={loading} />
      </Stack>
    </Box>
  );
}
