import FontAwesome from '@/shared/components/fontawesome';
import SvgColor from '@/shared/components/svg-color';
import { pxToRem } from '@/shared/theme/typography';
import { faCar, faWheelchair } from '@fortawesome/free-solid-svg-icons';
import { Box, Popover, Typography } from '@mui/material';
import { getBgColor, StatusColor } from '../utils/schedule-utils';

interface TimeSlotPopoverProps {
  anchorEl: HTMLElement | null;
  onClose: () => void;
  color: StatusColor;
  data: {
    circuit: string;
    trajet: string;
    schedule: string;
    wheelchairCount: number;
  };
}


export function TrajetDetailsPopover({ anchorEl, onClose, data, color }: TimeSlotPopoverProps) {
  const bgColor = getBgColor(color)
  return (
    <Popover
      open={Boolean(anchorEl)}
      anchorEl={anchorEl}
      onClose={onClose}
      disableRestoreFocus
      anchorOrigin={{
        vertical: 'center',
        horizontal: 'center',
      }}
      transformOrigin={{
        vertical: 'top',
        horizontal: 'center',
      }}
      sx={{
        pointerEvents: 'none',
        '& .MuiPopover-paper': {
          p: 1,
          mt: 3,
          borderRadius: 4,
          border: `2px solid ${color}`,
          bgcolor: bgColor,
          overflow: 'visible',
          boxShadow: 'none',
          '&::before': {
            content: '""',
            position: 'absolute',
            top: -10,
            left: '45%',
            width: '10%',
            aspectRatio: '1 / 1',
            backgroundColor: bgColor,
            transform: 'rotate(45deg)',
            borderRadius: 1,
            border: `2px solid ${color}`,
            borderBottom: 'none',
            borderRight: 'none',
            zIndex: 1,
          },
        },
      }}
    >
      <Box sx={{ display: 'flex', flexDirection: 'column', gap: 0 }}>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
          <SvgColor
            src="/assets/icons/menu/ic_exploitation.svg"
            sx={{
              color: { color },
              width: 13,
            }}
          />
          <Typography sx={{ fontSize: pxToRem(12), color: { color } }}>{data.circuit}</Typography>
        </Box>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
          <FontAwesome icon={faCar} color={color} width={13} />
          <Typography sx={{ fontSize: pxToRem(12), color: { color } }}>{data.trajet}</Typography>
        </Box>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
          <SvgColor
            src="/assets/icons/ic_date.svg"
            sx={{
              color: { color },
              width: 13,
            }}
          />{' '}
          <Typography sx={{ fontSize: pxToRem(12), color: { color } }}>{data.schedule}</Typography>
        </Box>
        <Box sx={{ display: 'flex', alignItems: 'center', gap: 2 }}>
          <FontAwesome icon={faWheelchair} color={color} width={13} />
          <Typography sx={{ fontSize: pxToRem(12), color: { color } }}>
            {data.wheelchairCount}
          </Typography>
        </Box>
      </Box>
    </Popover>
  );
}
