import { TableCell } from "@mui/material"
import { Box, styled } from "@mui/system"
import { Chip } from '@mui/material'

export const TimeSlotBlock = styled(Box)<{
  isDragging?: boolean
}>(({ theme, isDragging }) => ({
  position: "absolute",
  top: "0%",
  display: "flex",
  flexDirection: "column",
  justifyContent: "center",
  gap: "3%",
  fontSize: "0.75rem",
  opacity: isDragging ? 0.5 : 1,
  zIndex: 1,
  paddingLeft: 8,
  paddingRight: 36,
}))

export const DragHandle = styled(Box)({
  position: "absolute",
  width: "20px",
  top: 0,
  bottom: 0,
  right: "8px",
  display: "flex",
  alignItems: "center",
  justifyContent: "center",
  cursor: "grab",
})

export const AffectedIndicator = styled(Box)(({ theme }) => ({
  position: "absolute",
  top: 0,
  height: "100%",
  display: "flex",
  pl: 1,
  alignItems: "flex-start",
  justifyContent: "center",
  paddingLeft: "2%",
  zIndex: 0,
  overflow: "hidden",
  flexDirection: "column",
  gap: "3%",
}))

// Custom StatusChip specifically for driver statuses
export const DriverStatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
    ...(status === 'AVAILABLE' && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...(status === 'ABSENT' && {
      backgroundColor: '#FFE1E1',
      color: '#FF3434',
    }),
  },
}))

