import { ITrajet } from "@/shared/types/trajet"
import { StatusColor } from "./utils/schedule-utils"

export interface Driver {
  id: string
  name: string
  company: string
  vehicleId: string
  immatricule: string
}

export interface DriverTimeSlot {
  id: string
  driverId: string
  vehicleId: string
  startHeure: string,
  startMinute:string,
  endHeure: string,
  endMinute:string,
  date: string
  color:StatusColor
  trajet?: ITrajet
}

export interface ScheduleData {
  drivers: Driver[]
  timeSlots: DriverTimeSlot[]
  absences?: DriverAbsence[]
}

export interface DriverAbsence {
  id: string
  driverId: string
  startDate: string
  endDate: string
  startHeure: string
  startMinute: string
  endHeure: string
  endMinute: string
  type: "absence" | "vacation"
  justification: boolean
  reason?: string
}

export interface DraggableTimeSlotProps {
  slot: DriverTimeSlot
  width: number
  top: number
  height: string | number
  handlePopoverOpenT: (event: React.MouseEvent<HTMLElement>, slot: DriverTimeSlot) => void
  handlePopoverCloseT: () => void
  onDoubleClick: (slot: DriverTimeSlot) => void
  onCopySlot?: (slot: DriverTimeSlot) => void;
}

export interface DriverDetail {
  icon: any;
  label: string;
  value: string;
}