import { TableConfig, useTableManager } from "@/hooks/use-table-manager";
import { DEFAULT_DRIVER_ROADMAP_TABLE_HEAD, IRoadmap } from "@/shared/types/roadMap";

export function useRoadMapTable(initialData: IRoadmap[]) { 
  const roadmapConfig: TableConfig<IRoadmap> = {
    initialData,
    defaultTableHead: DEFAULT_DRIVER_ROADMAP_TABLE_HEAD,
  };

  return useTableManager<IRoadmap>(roadmapConfig);
}