import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { DEFAULT_SUBMITTED_ROADMAP_TABLE_HEAD } from '@/shared/_mock/_roadMap';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
import { SubmittedRoadMapDTO } from '@/shared/types/roadMap';

export function useSubmittedRoadMapTable() {
  const { submittedRoadMaps } = useRoadMapStore();

  const clientConfig: TableConfig<SubmittedRoadMapDTO> = {
    initialData: submittedRoadMaps,
    defaultTableHead: DEFAULT_SUBMITTED_ROADMAP_TABLE_HEAD,
    type: 'feuille de route soumise',
  };

  return useTableManager<SubmittedRoadMapDTO>(clientConfig);
}