'use client';

import React, { useState } from 'react';
import TableManager from '@/shared/components/table/table-manager';
import AddNewRoaMapTableRow from './add-new-roadmap-table-row';
import { IAddRoadmap } from '@/shared/types/driver';
interface AddNewRoadMapTableProps {
  table: any;
  filteredData: IAddRoadmap[];
  filters: any;
  tableHead: any[];
  notFound: boolean;
  dataToExport: any;
  activeTab: string;
  onFilterChange: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  onResetColumns: () => void;
  onColumnsChange: (columns: any[]) => void;
  handleEdit: (row: IAddRoadmap) => void;
  handleCopy: (row: IAddRoadmap) => void;
  handleView: (row: IAddRoadmap) => void;
}

export default function AddNewRoadMapTable({
  table,
  filteredData,
  filters,
  tableHead,
  notFound,
  dataToExport,
  activeTab,
  onFilterChange,
  onResetFilters,
  onResetColumns,
  onColumnsChange,
  handleEdit,
  handleCopy,
  handleView,
}: AddNewRoadMapTableProps) {
  const [selectedRow, setSelectedRow] = useState<any | null>(null);

  const renderRow = (row: IAddRoadmap) => (
    <AddNewRoaMapTableRow
      key={row.id}
      dense={table.dense}
      row={row}
      handleCopy={handleCopy}
      handleEdit={handleEdit}
      handleDetails={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  return (
    <>
      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={onFilterChange}
        renderRow={renderRow}
      />
    </>
  );
}
