'use client';

import React from 'react';
import {
  Box,
  FormControlLabel,
  Radio,
  RadioGroup,
  Stack,
  TextField,
  Typography,
} from '@mui/material';
import { TableType } from '@/shared/types/common';
import TableManager from '@/shared/components/table/table-manager';
import TableControlBar from '@/shared/components/table/table-control-bar';
import OldRoaMapsTableRow from "@/shared/sections/chauffeur/roadmap/components/roadmap-list/old-roadmaps/old-roadmaps-table-row"
import {IOldRoadmap } from '@/shared/types/driver';
import { CustomDateIcon } from '@/shared/components/form/form-field';
import {
  StyledRadioGroup,
  RoadMapStyledDatePicker,
  RoadMapStyledTimePicker,
} from '@/shared/theme/css';
import { LocalizationProvider } from '@mui/x-date-pickers';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { Dayjs } from 'dayjs';
import { AdapterDayjs } from '@mui/x-date-pickers/AdapterDayjs';
import { faClock, faEnvelope } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import { AddButton } from '@/shared/components/table/styles';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
import OldSubmittedRoadMapDetailsView from '../../../view/old-submitted-roadmap-details-veiw';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';

interface OldRoadMapTableProps {
  table: any;
  filteredData: IOldRoadmap[];
  filters: any;
  tableHead: any[];
  notFound: boolean;
  dataToExport: any;
  activeTab: string;
  onFilterChange: (key: string, value: string, condition: string) => void;
  onResetFilters: () => void;
  onResetColumns: () => void;
  onColumnsChange: (columns: any[]) => void;
  handleEdit: (row: IOldRoadmap) => void;
  handleCopy: (row: IOldRoadmap) => void;
  handleView: (row: IOldRoadmap) => void;
  activeTabData : IOldRoadmap;
}

export default function OldSubmittedRoadMapsTable({
  table,
  filteredData,
  filters,
  tableHead,
  notFound,
  dataToExport,
  activeTab,
  onFilterChange,
  onResetFilters,
  onResetColumns,
  onColumnsChange,
  handleEdit,
  handleCopy,
  handleView,
  activeTabData,
}: OldRoadMapTableProps) {

  const {
    oldSubmittedRoadMaps,
    getAllSubmittedRoadMaps,
    loading,
    error,
    totalElements
  } = useRoadMapStore();

  
  
  const renderRow = (row: IOldRoadmap) => (
    <OldRoaMapsTableRow
      key={row.id}
      dense={table.dense}
      row={row}
      handleCopy={handleCopy}
      handleEdit={handleEdit}
      handleDetails={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  const isList = activeTab === "list"

  return (
    <ConditionalComponent
      isValid={isList}
      defaultComponent={<OldSubmittedRoadMapDetailsView activeTabData={activeTabData}/>}
    >
      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={onFilterChange}
        renderRow={renderRow}
        loading={loading}  
        count={totalElements}
      />
    </ConditionalComponent>

  );
}
