import Checkbox from '@mui/material/Checkbox';
import TableCell from '@mui/material/TableCell';
import IconButton from '@mui/material/IconButton';
import type { TableColumn } from '@/shared/types/common';
import { ContratStyledRow, getStatusColor } from '@/shared/sections/contract/styles';
import { IValidRoadmap } from '@/shared/types/driver';
import SvgColor from '@/shared/components/svg-color';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

type Props = {
  selected: boolean;
  row: IValidRoadmap;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
  onClickOldRoadMaps: (roadmap: IValidRoadmap) => void;
};

export default function ValidRoadmapTableRow({
  dense,
  row,
  selected,
  onSelectRow,
  columns,
  onClickOldRoadMaps,
}: Props) {
  const renderCellContent = (column: any, value: any) => {
    switch (column.id) {
      case 'anciennesListes':
        return (
          <CustomTooltip title={column.label} arrow>
            <IconButton
              sx={{ py: 0, px: 0.5 }}
              onClick={(e) => {
                e.stopPropagation();
                onClickOldRoadMaps(row);
              }}
            >
              <SvgColor
                src="/assets/icons/navbar/ic_table.svg"
                sx={{ width: 16 }}
              />
            </IconButton>
          </CustomTooltip>
        );
      default:
        return value;
    }
  };

  return (
    <ContratStyledRow hover style={{ cursor: 'pointer' }}>
      {columns.map((column: any, index: number) => (
        <TableCell
          key={column.id}
          align={column.align}
          sx={{
            whiteSpace: 'nowrap',
            ...(index === 0 && {
              position: 'relative',
            }),
            py: dense ? 0 : 2,
          }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: 'absolute', top: 0, left: -4, height: '100%', color: getStatusColor(row.driverName),
              }}
            />
            </ConditionalComponent>
          {renderCellContent(column, row[column.id as keyof IValidRoadmap])}
        </TableCell>
      ))}
    </ContratStyledRow>
  );
}
