'use client';
import { Grid, Box, Typography } from '@mui/material';
import { useFormikContext } from 'formik';
import { IRoadMapMileage } from '@/shared/types/driver-roadmap';
import { roadMapFormFields } from '../../utils/form-field-roadmap';
import { FormFieldType } from '@/shared/types/common';
import FormField from '@/shared/components/form/form-field';
import { pxToRem } from '@/shared/theme/typography';

export default function CreateRoadMapMileage() {
  const { values, errors, touched, handleBlur, setFieldValue } = useFormikContext<IRoadMapMileage>();

  const renderField = (field: FormFieldType<IRoadMapMileage>) => (
    <FormField
      field={field}
      value={values[field.name]}
      onChange={(name, value) => setFieldValue(name, value)}
      error={touched[field.name] ? (errors[field.name] as string | undefined) : undefined}
      onBlur={handleBlur}
      isReadOnly={false}
    />
  );

  return (
    <>
      <Typography
        variant="h5"
        sx={{ color: 'primary.main', fontSize: pxToRem(22), fontWeight: 'bold', m: 3 }}
      >
        Intervalle Kilométrique
      </Typography>
      <Box sx={{ backgroundColor: 'white', borderRadius: 2, p: 3 }}>
        <Grid container spacing={3}>
          {roadMapFormFields.map((field) => (
            <Grid item xs={12} sm={6} key={field.name}>
              {renderField(field)}
            </Grid>
          ))}
        </Grid>
      </Box>
    </>
  );
}
