import { Box, Typography } from '@mui/material';
import ValidationTable, { ValidationTableConfig } from './validation-table';
import DriverStatsTable from './DriverStatsTable';
import { AddButton } from '@/shared/components/table/styles';
import ValidationTableFinal from './validation-table-final';
import { useState } from 'react';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

const tableConfig: ValidationTableConfig = {
    trajets: [
      { id: "1", label: "Trajet 1" },
      { id: "2", label: "Trajet 2" },
      { id: "3", label: "Trajet 3" },
      { id: "4", label: "Trajet 4" },
    ],
    additionalColumns: [
      { id: "total_journee", label: "Total journée" },
      { id: "total_centiemes", label: "Total en centièmes" },
      { id: "deduction", label: "Déduction ou vacation" },
      { id: "heures_payees", label: "Heures payées en centièmes" },
      { id: "delta_forfait", label: "Delta forfait-réel -déduc" },
      { id: "forfait", label: "Forfait" },
      { id: "heures_nuit", label: "Heures de nuit" },
      { id: "heures_attente", label: "Heures d'attente" },
      { id: "nb_vacation", label: "Nb de vacation" },
    ],
    dates: Array(3).fill("01/03/2023"),
  }

type FinalResultTableProps = {
  showButton?: boolean;
};

export default function FinalResultTable({ showButton = false }: FinalResultTableProps) {
  
  return (
    <Box sx={{ bgcolor: 'white', borderRadius: '12px', mt: 3, py:3, px:1 }}>
      <Typography
        variant="h5"
        gutterBottom
        component="div"
        sx={{
          textAlign: 'center',
          color: 'primary.main',
          pb: 3,
          fontWeight: '600',
        }}
      >
        {'Résultat final après validation'}
      </Typography>
      <ValidationTableFinal tableConfig={tableConfig} />
      <DriverStatsTable />
      <Box sx={{ display: "flex", justifyContent: "center", mt: 2 }}>
        <ConditionalComponent
          isValid={showButton}
          defaultComponent={null}
        >
          <Box sx={{ display: "flex", justifyContent: "center", mt: 2 }}>
            <AddButton variant="contained" sx={{ p: 1 }}>
              Validation Final
            </AddButton>
          </Box>
        </ConditionalComponent>
      </Box>
    </Box>
  );
}
