"use client"

import ScheduleVerificationTable from "@/shared/components/roadmap/schedule-verification-table"
import {
  _driverScheduleList,
  _geolocationList,
  DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD,
  DEFAULT_GEOLOCATION_TABLE_HEAD,
} from "@/shared/_mock/_roadMap"
import WeeklyVerificationPanel, { VerificationTableType } from "@/shared/components/roadmap/weekly-verification-panel"

export default function DriverCombinedTable() {
  return (
    <WeeklyVerificationPanel
      title="Vérification du planning de chauffeur et des données de géolocalisation"
      tableConfigs={[
        {
          title: "Planning VSN",
          columns: DEFAULT_DRIVER_SCHEDULE_TABLE_HEAD,
          data: _driverScheduleList,
          verificationType: VerificationTableType.vsnschedule,
          component: ScheduleVerificationTable,
        },
        {
          title: "Géolocalisation",
          columns: DEFAULT_GEOLOCATION_TABLE_HEAD,
          data: _geolocationList,
          verificationType: VerificationTableType.geolocation,
          component: ScheduleVerificationTable,
        },
      ]}
    />
  )
}

