'use client';
import {
  Typography,
  Grid,
  Dialog,
  DialogTitle,
  DialogContent,
} from '@mui/material';
import { LocalizationProvider } from '@mui/x-date-pickers/LocalizationProvider';
import { AdapterDateFns } from '@mui/x-date-pickers/AdapterDateFns';
import { faClock, faTimes } from '@fortawesome/free-solid-svg-icons';
import dynamic from 'next/dynamic';
import { MapType } from '@/shared/types/Maps';
import { _mockTripRoutes } from '@/shared/_mock/_preparationCircuit';
import GeolocTable from './geolocTable';
import { JourneySummaryDriver } from '@/shared/components/google-maps/journey-summary-driver';
import { AddButton } from '@/shared/components/table/styles';
import { RoadMapStyledTimePicker } from '@/shared/theme/css';
import FontAwesome from '@/shared/components/fontawesome';

const MapView = dynamic(() => import('@/shared/components/google-maps/maps'), {
  ssr: false,
});

interface Props {
  open: any;
  onClose: () => void;
}
export const FORM_ITEMS = ['Heure de depart', "Heure d'arrivée", "Heure d'attente"];

export default function VsnScheduleModal({ open, onClose }: Props) {
  return (
    <Dialog
      open={open}
      onClose={onClose}
      fullWidth
      maxWidth="xl"
      sx={{ width: '100%', maxWidth: 'none', mx: 'auto', my: 'auto' }}
    >
      <DialogTitle sx={{ m: 0, p: 2, pb: 1 }}>
        <Typography
          variant="h5"
          component="div"
          sx={{
            color: 'primary.main',
            fontWeight: 700,
          }}
        >
          Détails du Trajet
        </Typography>
      </DialogTitle>
      <DialogContent>
        <Typography
          variant="h6"
          sx={{ fontWeight: 'bold', color: 'primary.main', textAlign: 'center' }}
        >
          La carte du planning du chauffeur
        </Typography>
        <JourneySummaryDriver departureTime="13.9487km" arrivalTime="20.97 min" />
        <MapView height="460px" Submodule={MapType.CIRCUIT} routes={_mockTripRoutes} />
        <Typography
          variant="h6"
          sx={{ fontWeight: 'bold', color: 'primary.main', textAlign: 'center', mt: 3 }}
        >
          La carte des données de géolocalisation
        </Typography>
        <Grid container spacing={2} sx={{ mb: 2 }}>
          <Grid item xs={5} sx={{ my: 2 }}>
            <GeolocTable />
          </Grid>
          <Grid item xs={7} sx={{ my: 2 }}>
            <MapView height="460px" Submodule={MapType.CIRCUIT} routes={_mockTripRoutes} />
          </Grid>
          <Grid item xs={12} container>
            <LocalizationProvider dateAdapter={AdapterDateFns}>
              <Grid container>
                <Grid item xs={11} container spacing={2}>
                  {FORM_ITEMS.map((item) => (
                    <Grid item key={`${item}`}>
                      <RoadMapStyledTimePicker
                        label={item}
                        slots={{
                          openPickerIcon: () => (
                            <FontAwesome icon={faClock} sx={{ color: 'primary.main' }} />
                          ),
                        }}
                        slotProps={{
                          textField: {
                            fullWidth: true,
                            placeholder: "Sélectionner l'heure",
                          },
                        }}
                        views={['hours', 'minutes']}
                        format="HH:mm"
                      />
                    </Grid>
                  ))}
                </Grid>
                <Grid item xs={1} style={{ display: 'flex', justifyContent: 'flex-end' }}>
                  <AddButton variant="contained" sx={{ px: 4 }}>
                    Valider
                  </AddButton>
                </Grid>
              </Grid>
            </LocalizationProvider>
          </Grid>
        </Grid>
      </DialogContent>
    </Dialog>
  );
}
