'use client';
import { Box, Typography } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TabbedForm from '@/shared/components/tabs/tabbed-form';
import StatCards, { StatCardProps } from '../../../../components/charts/roadmap-stats-cards';
import { ScrollBox } from '@/shared/theme/css';
import ValidRoadmapListView from '../components/roadmap-list/valid-roadmap/valid-roadmap-table';
import { useEffect, useState } from 'react';
import InValidRoadmapListView from '../components/roadmap-list/invalid-roadmap/invalid-roadmap-table';
import { useRoadMapStore } from '@/shared/api/stores/roadMapStore';
import { faClipboardList, faUserTie } from '@fortawesome/free-solid-svg-icons';

export default function RoadMapListView() {
  const [isList, setIsList] = useState(true);

  const handleIsListChange = (isListValue: boolean) => {
    setIsList(isListValue);
  };
  const { roadMapStatistics, getRoadMapStatistics, loading, error } = useRoadMapStore();

  useEffect(() => {
    getRoadMapStatistics();
  }, []);

  const statCardsData: StatCardProps[] = [
    {
      title: 'Total des chauffeurs actifs',
      subtitle: 'Chauffeurs actifs',
      value: (roadMapStatistics?.activeDrivers ?? 0).toString(),
      color: 'primary',
      icon: faUserTie,
    },
    {
      title: 'Feuilles de route soumises',
      subtitle: 'Soumises',
      value: (roadMapStatistics?.submittedRoadmaps ?? 0).toString(),
      color: 'success',
      icon: faClipboardList,
    },
    {
      title: 'Feuilles de route en attente',
      subtitle: 'Non validées',
      value: (roadMapStatistics?.notValidatedRoadmaps ?? 0).toString(),
      color: 'warning',
      icon: faClipboardList,
    },
    {
      title: 'Feuilles de route non soumises',
      subtitle: 'Non soumises',
      value: (roadMapStatistics?.notSubmittedRoadmaps ?? 0).toString(),
      color: 'error',
      icon: faClipboardList,
    },
  ];

  const filterTabs = [
    {
      label: 'All',
      status: 'ALL',
      content: <InValidRoadmapListView onIsListChange={handleIsListChange} status="ALL" />,
    },
    {
      label: 'Traitée',
      status: 'VALIDE',
      content: <InValidRoadmapListView onIsListChange={handleIsListChange} status="VALIDE" />,
    },
    {
      label: 'En cours',
      status: 'IN_PROGRESS',
      content: <InValidRoadmapListView onIsListChange={handleIsListChange} status="IN_PROGRESS" />,
    },
    {
      label: 'Non Traitée',
      status: 'NON_VALIDE',
      content: <InValidRoadmapListView onIsListChange={handleIsListChange} status="NON_VALIDE" />,
    },
    { label: 'Validée', content: <ValidRoadmapListView onIsListChange={handleIsListChange} /> },
  ];

  return (
    <ScrollBox sx={{ height: `calc(100vh - ${HEADER.H_DESKTOP + 20}px)` }}>
      <Typography
        variant="h5"
        sx={{
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
          mb: 3,
        }}
      >
        Feuille de Route
      </Typography>
      {isList ? <StatCards data={statCardsData} /> : <></>}
      <Box mt={4}>
        <TabbedForm tabs={filterTabs} />
      </Box>
    </ScrollBox>
  );
}
