"use client";

import { useEffect, useState } from "react";
import FormContainer from "@/layouts/form/form-container";
import type { IRouteTracking } from "@/shared/types/suivi-trajet";
import type { ModeType } from "@/shared/types/common";
import dynamic from "next/dynamic";
import { JourneySummary } from "@/shared/components/google-maps/journey-summary";
import { MapType } from "@/shared/types/Maps";
import { _mockRoutes, _mockTripRoutes } from "@/shared/_mock/_preparationCircuit";
const MapView = dynamic(() => import('@/shared/components/google-maps/maps'), {
  ssr: false,
});
interface SuiviTrajetFormProps {
  suiviTrajet: IRouteTracking;
  mode: ModeType;
  onClose: () => void;
}

export default function SuiviTrajetForm({ suiviTrajet, mode, onClose }: SuiviTrajetFormProps) {
  const [formData, setFormData] = useState<IRouteTracking>(suiviTrajet);

  useEffect(() => {
    setFormData(suiviTrajet);
  }, [suiviTrajet]);

  return (
    <FormContainer titre="Fiche suivi trajet">
      <form>
      <JourneySummary
        distance="13.9487km"
        duration="20.97 min"
        trafficDate="06/10/2024"
        trafficTime="10:00:00"
      />
        <MapView height="calc(100vh - 360px)" Submodule={MapType.CIRCUIT} routes={_mockTripRoutes}/>
      </form>
    </FormContainer>
  );
}
