import React from 'react';
import TableCell from '@mui/material/TableCell';
import { TableColumn } from '@/shared/types/common';
import { dateFormat, formatDate } from '@/utils/format-time';
import JoursAttribuesGrid from '@/shared/sections/circuit/components/circuit-form/chauffeur/components/JoursAttribuesGrid';
import { Stack } from '@mui/system';
import FontAwesome from '@/shared/components/fontawesome';
import { faArrowRight } from '@fortawesome/free-solid-svg-icons';
import { TrajetStyledRow } from '@/shared/sections/contract/styles';
import { ITripDriverAssignment } from '@/shared/types/circuit';

type Props = {
  handleDetails: (contrat:ITripDriverAssignment) => void;
  selected: boolean;
  row: ITripDriverAssignment;
  dense: boolean;
  onSelectRow: VoidFunction;
  columns: TableColumn[];
};

export default function ChauffeurTableRow({
  row,
  handleDetails,
  selected,
  dense,
  onSelectRow,
  columns,
}: Props) {

  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      case 'assignmentStartDate':
      case 'assignmentEndDate':
        return formatDate(value, dateFormat.isoDate);
      case 'weeklyAssignmentSchedule':
        return <JoursAttribuesGrid weeklyAssignmentSchedule={value} />;
      case 'horaires':
        return (
          <Stack direction="row" alignItems="center">
            {value.depart}
            <FontAwesome icon={faArrowRight} width={12} sx={{ px: 1 }} />
            {value.arriver}
          </Stack>
        );
      default:
        return value;
    }
  };


  return (
          <TrajetStyledRow
            key={row.id}
            style={{ cursor: 'pointer' }}
          >
            {columns.map((column: any) => (
              <TableCell
                onDoubleClick={() => handleDetails(row)}
                key={column.id}
                align={column.align || 'left'}
                sx={{ whiteSpace: 'nowrap', py: column.id === 'etat' ? 0.2 : dense ? 0.5 : 1 }}
              >
                {renderCellContent(column.id, row[column.id as keyof ITripDriverAssignment])}
              </TableCell>
            ))}
          </TrajetStyledRow>
        );
      };
  

