import { Circuit, CalculationType, CircuitState, SaveCircuit } from '@/shared/types/circuit';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';

const initialData = {
  circuitState: CircuitState.CONTROLLED,
  circuitCode: '',
  timeTolerance: 0,
  titled: '',
  startDate: '', 
  endDate: '',   
  mainDriver: 0,
  mainEstablishment: 0,
  observation: '',
  colorCode: '',
  calculationType: CalculationType.URBAN,
}

const circuitConfig: TabConfig<Circuit> = {
  type: 'circuit',
  listTitle: 'Liste des circuits',
  newItemTitle: 'Nouveau circuit',
  initialData: initialData as Circuit,
  getItemCode: (circuit) => circuit.circuitCode,
};

export function useCircuitTabs() {
  return useTabsManager<Circuit>(circuitConfig);
}

