'use client';

import React from 'react';
import { Box, Stack } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useCircuitTabs } from '../hooks/use-circuit-tabs';
import { useCircuitTable } from '../hooks/use-circuit-table';
import TabsCustom from '@/shared/components/tabs/tabs-custom';
import CircuitTable from '../components/circuit-table';
import CircuitForm from './circuit-new-view';
import { Circuit } from '@/shared/types/circuit';
import { TableType } from '@/shared/types/common';
import { UnsavedChangesDialog } from '@/shared/components/dialog/UnsavedChangesDialog';
export default function CircuitListView() {
  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
    markTabAsSaved,
  } = useCircuitTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    dataToExport,
  } = useCircuitTable();
  const activeTabData = React.useMemo(() => {
    return tabs.find((tab) => tab.id === activeTab);
  }, [tabs, activeTab]);
  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type = {TableType.Circuit}
          handleTabAdd={handleTabAdd}
          activeTab={activeTab}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
        />
      </Stack>

      <TabsCustom
        type = {TableType.Circuit}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />

      {activeTab === 'list' ? (
        <CircuitTable
          filteredData={filteredData}
          table={table}
          tableHead={tableHead}
          notFound={notFound}
          filters={filters}
          onFilterChange={handleFilterChange}
          handleView={handleView}
        />
      ) : (
        <CircuitForm
          key={activeTab}
          circuit={activeTabData?.content as Circuit}
          mode={activeTabData?.mode || 'view'}
          onSave={handleSave}
          onClose={(isSaved) => handleCancel(activeTab, isSaved)}
          onEdit={handleEdit}
          updateTabContent={updateTabContent}
          tabId={activeTab}
          markTabAsSaved={markTabAsSaved}
          hasUnsavedChanges={activeTabData?.hasUnsavedChanges}
          />
      )}
      <UnsavedChangesDialog
        open={showConfirmDialog}
        onClose={() => setShowConfirmDialog(false)}
        onConfirm={() => handleConfirmDialogAction()}
        onCancel={() => setShowConfirmDialog(false)}
      />
    </Box>
  );
}
