import { _clients } from '@/shared/_mock/_client';
import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { IClient } from '@/shared/types/client';
import { TableColumn } from '@/shared/types/common';

const CLIENT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° Client", type: "text", align: "left" },
  { id: "lastName", label: "Nom", type: "text", align: "left" },
  { id: "firstName", label: "Prénom", type: "text", align: "left" },
  { id: "clientType", label: "Type de Client", type: "text", align: "center" },
  { id: "siret", label: "Siret", type: "text", align: "center" },
  { id: "mainBranch", label: "Branche mère", type: "text", align: "center" },
  { id: "apeCode", label: "Code APE", type: "text", align: "center" },
  { id: "observation", label: "Observation", type: "text", align: "center" },
  { id: "email", label: "Mail", type: "text", align: "center" },
  { id: "landlinePhone", label: "Téléphone fixe", type: "text", align: "center" },
  { id: "phoneNumber", label: "Téléphone mobile", type: "text", align: "center" },
  { id: "bankName", label: "Banque", type: "text", align: "center" },
  { id: "iban", label: "IBAN", type: "text", align: "center" },
  { id: "signatureDate", label: "Date signature", type: "date", align: "center" },
  { id: "accountingAccount", label: "Compte comptable", type: "text", align: "center" },
  { id: "auxiliaryAccount", label: "Compte auxiliaire", type: "text", align: "center" },
  { id: "salesAccount", label: "Compte de vente", type: "text", align: "center" },
  { id: "paymentDate", label: "Date de règlement", type: "date", align: "center" },
  { id: "portalAssignment", label: "Attribution d'un portail", type: "status", align: "center" },
  { id: "", label: "Action" },
];

export function useClientTable(initialData: IClient[]) { 
  const clientConfig: TableConfig<IClient> = {
    initialData, 
    defaultTableHead: CLIENT_TABLE_HEAD,
  };

  return useTableManager<IClient>(clientConfig);
}


  