import * as yup from 'yup';

export const contractSchema = yup.object().shape({
  title: yup.string().required('Le titre est requis'),
  contractCode: yup.string().required('Le code contrat est requis'),
  startDate: yup.date().required('La date de début est requise'),
  endDate: yup.date()
    .required('La date de fin est requise')
    .min(yup.ref('startDate'), 'La date de fin doit être postérieure à la date de début'),
  marketDate: yup.date().required('La date du marché est requise'),
  renewalDate: yup.date().nullable(),
  priceRevisionDate: yup.date().required('La date de révision des prix est requise'),
  marketNumber: yup.string(),
  status: yup.string().required('Le statut est requis'),
  pricingGridType: yup.number().required('La grille de prix est requise'),
  priceRevisionFrequencyMonths: yup.number().required('La fréquence est requise'),
  contractColor: yup.string().required('La couleur est requise'),
  contractualSubsets: yup.array().of(yup.string()),
  commitmentNumber: yup.string(),
  contractDurationMonths: yup.number(),
  renewalStatus: yup.string(),
  tadType: yup.string(),
  googleTADVisibility: yup.boolean(),
  orderNumber: yup.number(),
  purchaseOrder: yup.number(),
  agencyId: yup.number().required('L’agence est requise'),
  departmentId: yup.number().required('Le département est requis'),
  lotId: yup.number().required('Le lot est requis'),
  observation: yup.string()
});
