// hooks/use-attendance-tabs.ts
import { AttendanceSheet, AttendanceSheetStatus, RouteSheetDTO } from '@/shared/types/attendance-sheet';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { TableType } from '@/shared/types/common';
import { AttendanceUnion } from '../utils/attendance-utils';

// Interface pour le contenu des onglets d'attendance
export interface TabContentBase {
  id: string;
  data: AttendanceSheet;
  currentStep: "form" | "sheet";
  attendance: AttendanceUnion;
  routeSheets?: RouteSheetDTO[];
}

const initialValues: TabContentBase = {
  id: '',
  data: {
    id: '',
    number: '',
    year: 0,
    month: '',
    departmentId: 0,
    departmentName: '',
    circuitId: '',
    circuitName: '',
    status: AttendanceSheetStatus.ACTIVE,
    passengers: [],
    establishment: '',
    calendar: null,
    presenceDaysCount: 0,
    absenceDaysCount: 0,
    schoolDaysCount: 0,
    transportArCount: 0,
    createdAt: '',
    updatedAt: '',
    isActive: true,
  },
  currentStep: "form",
  attendance: {},
  routeSheets: [],
};

const attendanceTabsConfig: TabConfig<TabContentBase> = {
  type: TableType.AttendanceSheet,
  listTitle: 'Historique feuille de présence',
  newItemTitle: 'Nouvelle feuille de présence',
  initialData: initialValues,
  getItemCode: (attendance) => attendance.data.circuitName || 'Nouvelle',
};

export function useAttendanceTabs() {
  return useTabsManager<TabContentBase>(attendanceTabsConfig);
}

export type AttendanceTabContent = TabContentBase;