
import type { FormFieldType } from "@/shared/types/common"
import {
  faUser,
  faSchool,
  faMapMarkerAlt,
  faPhone,
  faCalendarAlt,
  faUserTie,
  faCalendarDay,
  faCheckSquare,
  faTimesCircle,
  faBus,
  faStickyNote,
  faMapLocationDot,
  faHome,
} from "@fortawesome/free-solid-svg-icons"

import { IAttendanceNotCher, IAttendanceSheetCher } from "@/shared/types/attendance-sheet"

export const studentFields: FormFieldType<IAttendanceSheetCher>[] = [
  {
    name: "nom",
    label: "Nom Élève",
    type: "text",
    placeholder: "Entrez le nom de l'élève",
    required: true,
    icon: faUserTie,
  },
  {
    name: "prenom",
    label: "Prénom Élève",
    type: "text",
    placeholder: "Entrez le prénom de l'élève",
    required: true,
    icon: faUserTie,
  },
]

export const schoolFields: FormFieldType<IAttendanceSheetCher>[] = [
  {
    name: "etablissement",
    label: "Nom Établissement",
    type: "text",
    placeholder: "nom de l'établissement",
    icon: faHome
  },
  {
    name: "adresse",
    label: "Adresse Établissement",
    type: "text",
    placeholder: "Entrez l'adresse de l'établissement",
    required: true,
    icon: faMapLocationDot,
  },
  {
    name: "telephone",
    label: "Tel Établissement",
    type: "text",
    placeholder: "Entrez le numéro de téléphone",
    required: true,
    icon: faPhone,
  },
]

export const signatureFields: FormFieldType<IAttendanceSheetCher>[] = [
  {
    name: "completionDate",
    label: "Le",
    type: "date",
    icon: faCalendarAlt,
  },
  {
    name: "nomResponsable",
    label: "Nom et qualite du responsable de l'etablissement",
    type: "text",
    placeholder: "Entrez l'adresse de l'établissement",
    icon: faUserTie,
  },
]

export const summaryFields: FormFieldType<IAttendanceSheetCher>[] = [
  {
    name: "joursClasse",
    label: "Nombre de jours de classe",
    type: "number",
    placeholder: "0",
    required: false,
    icon: faCalendarDay,
  },
  {
    name: "joursPresence",
    label: "Nombre de jours de présence",
    type: "number",
    placeholder: "0",
    required: false,
    icon: faCheckSquare,
  },
  {
    name: "joursAbsence",
    label: "Nombre de jours d'absence",
    type: "number",
    placeholder: "0",
    required: false,
    icon: faTimesCircle,
  },
  {
    name: "transportAR",
    label: "Nombre de transport AR",
    type: "number",
    placeholder: "0",
    required: false,
    icon: faBus,
  },
]


// Not Cher
export const transportFields: FormFieldType<IAttendanceNotCher>[] = [
  {
    name: "driver",
    label: "Transporteur",
    type: "text",
    placeholder: "nom du transporteur",
    icon: faUserTie
  },
  {
    name: "circuit",
    label: "Circuit",
    type: "text",
    placeholder: "Entrez le circuit",
    icon:"/assets/icons/menu/ic_exploitation.svg"
  },
  {
    name: "etablissement",
    label: "Nom Établissement",
    type: "text",
    placeholder: "nom de l'établissement",
    icon: faHome
  },
];

export const studentNamesFields: FormFieldType<IAttendanceNotCher>[] = [
  {
    name: "eleveA",
    label: "Élève A",
    type: "text",
    placeholder: "Nom de l'élève A",
    icon: faUserTie,
  },
  {
    name: "eleveB",
    label: "Élève B",
    type: "text",
    placeholder: "Nom de l'élève B",
    icon: faUserTie,
  },
  {
    name: "eleveC",
    label: "Élève C",
    type: "text",
    placeholder: "Nom de l'élève C",
    icon: faUserTie,
  },
  {
    name: "eleveD",
    label: "Élève D",
    type: "text",
    placeholder: "Nom de l'élève D",
    required: false,
    icon: faUserTie,
  },
  {
    name: "eleveE",
    label: "Élève E",
    type: "text",
    placeholder: "Nom de l'élève E",
    required: false,
    icon: faUserTie,
  }
]
export const observationField: FormFieldType<IAttendanceNotCher> = 
    {
      name: 'observation',
      label: 'Observation',
      placeholder: 'Ajoutez une note ou une observation',
      type: 'textarea',
      icon: faStickyNote,
    }
