import { circuitOptions } from "@/shared/_mock/_circuit";
import { AttendanceSheet, AttendanceSheetList } from "@/shared/types/attendance-sheet";
import { FormFieldType } from "@/shared/types/common"
import { Departements, IAttendanceSheet, Months } from "@/shared/types/etablissement"
import { faBuilding, faMap } from "@fortawesome/free-regular-svg-icons";

export const YEARS = Array.from({ length: 5 }, (_, i) => ({
  label: `${new Date().getFullYear() - i}`,
  value: `${new Date().getFullYear() - i}`,
}))

export const DEPARTEMENT_OPTIONS = Object.values(Departements).map((departement) => ({
  label: departement,
  value: departement,
}));

export const MONTH_OPTIONS = Object.values(Months).map((month,index) => ({
  label: month,
  value: (index+1).toString(),
}));

export const MONTHS_OPTIONS = [
  { label: 'Janvier', value: '1' },
  { label: 'Février', value: '2' },
  { label: 'Mars', value: '3' },
  { label: 'Avril', value: '4' },
  { label: 'Mai', value: '5' },
  { label: 'Juin', value: '6' },
  { label: 'Juillet', value: '7' },
  { label: 'Août', value: '8' },
  { label: 'Septembre', value: '9' },
  { label: 'Octobre', value: '10' },
  { label: 'Novembre', value: '11' },
  { label: 'Décembre', value: '12' }
];
export const vacationFormFields=( 
  departmentOptions: { value: string; label: string }[],
  circuitOptions: { value: string; label: string }[]): FormFieldType<AttendanceSheet>[] => [
  {
    name: 'circuitId',
    label: 'Circuit',
    type: 'combobox',
    options: circuitOptions,
    required: true,
    icon: faMap,
  },
    {
    name: 'departmentId',
    label: 'Département',
    type: 'select',
    options: departmentOptions,
    required: true,
    icon: faBuilding,
  },
  
  {
    name: 'year',
    label: 'Année',
    type: 'select',
    options:YEARS,
    required: true,
  },
  {
    name: 'month',
    label: 'Mois',
    type: 'select', 
    options: MONTHS_OPTIONS,
    required: true,
  },
  ]