"use client"

import { Typography } from "@mui/material"
import type { TableConfig } from "@/hooks/use-table-manager"
import { _vacances, DEFAULT_VACANCES_TABLE_HEAD } from "@/shared/_mock/_vacance"
import type { IVacance } from "@/shared/types/vacance"
import VacanceCalendarListView from "../../vacance/view/vacance-calander-list-view"
import { pxToRem } from "@/shared/theme/typography"

const vacancesConfig: TableConfig<IVacance> = {
  initialData: _vacances,
  defaultTableHead: DEFAULT_VACANCES_TABLE_HEAD,
}

export default function EstablishmentVacanceForm() {
  return (
    <>
      <Typography
        sx={{
          mb: 3,
          fontSize: pxToRem(30),
          color: "primary.main",
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        La période de vacance des enseignants
      </Typography>

      <VacanceCalendarListView isChild={true} vacancesConfig={vacancesConfig} />
    </>
  )
}

