"use client"

import type { IFuelFee } from "@/shared/types/flottes/fuelFee"
import { INITIAL_FUEL_FEE_DATA } from "@/shared/_mock/flottes/_fuelFees"
import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"

const fuelFeeConfig: TabConfig<IFuelFee> = {
  type: "frais carburant",
  listTitle: "Liste des frais carburant",
  newItemTitle: "Nouveau frais carburant",
  initialData: INITIAL_FUEL_FEE_DATA,
  getItemCode: (fuelFee) => fuelFee.id,
}

export function useFuelFeeTabs() {
  return useTabsManager<IFuelFee>(fuelFeeConfig)
}
