'use client';

import React from 'react';
import { Box, Stack } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useFuelFeeTabs } from '../hooks/use-fuel-fee-tabs';
import { useFuelFeeTable } from '../hooks/use-fuel-fee-table';
import { TableType } from '@/shared/types/common';
import { IFuelFee } from '@/shared/types/flottes/fuelFee';
import CustomTabs from '@/shared/components/tabs/tabs-custom';
import TableManager from '@/shared/components/table/table-manager';
import FuelFeeForm from './fuel-fee-new-view';
import FuelFeeTableRow from './fuel-fee-table-row';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import { ColumnButton, mainColor } from '@/shared/components/table/styles';
import FontAwesome from '@/shared/components/fontawesome';
import { faFileImport, faGear } from '@fortawesome/free-solid-svg-icons';

import { useBoolean } from '@/hooks';
import ConditionalComponent from '../../../../../components/table/ConditionalComponent';
import { UnsavedChangesDialog } from '@/shared/components/dialog/UnsavedChangesDialog';

export default function FuelFeeListView() {
  const uploadFile = useBoolean(false);

  const {
    tabs,
    activeTab,
    handleTabClose,
    handleTabChange,
    handleTabAdd,
    handleEdit,
    handleView,
    handleCancel,
    handleCopy,
    setTabHasUnsavedChanges,
    showConfirmDialog,
    setShowConfirmDialog,
    handleConfirmDialogAction,
    updateTabContent,
  } = useFuelFeeTabs();

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    dataToExport,
  } = useFuelFeeTable();

  const activeTabData = React.useMemo(() => {
    return tabs.find((tab) => tab.id === activeTab);
  }, [tabs, activeTab]);

  const renderRow = (row: IFuelFee) => (
    <FuelFeeTableRow
      key={row.id}
      row={row}
      handleCopyFuelFee={handleCopy}
      handleEditFuelFee={handleEdit}
      handleDetailsFuelFee={handleView}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead.slice(0, -1)}
    />
  );

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
      }}
    >
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type={TableType.FuelFee}
          handleTabAdd={handleTabAdd}
          activeTab={activeTab}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead.slice(0, -1)}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
        />
      </Stack>
        <Stack
          flexGrow={0}
          direction="row"
          alignItems="center"
          justifyContent="flex-end"
          sx={{ visibility: activeTab !== 'list' ? 'hidden' : 'visible' }}
          spacing={{ xs: 0.5, sm: 1 }}
        >
          <CustomTooltip title={`Importer les frais de carburant en masse`} arrow>
            <ColumnButton
              variant="contained"
              sx={mainColor}
              onClick={uploadFile.onTrue}
              endIcon={<FontAwesome icon={faFileImport} width={16} />}
            >
              Importer en masse
            </ColumnButton>
          </CustomTooltip>
          <CustomTooltip title={`Recalculer`} arrow>
            <ColumnButton
              variant="contained"
              sx={mainColor}
              onClick={void 0}
              endIcon={<FontAwesome icon={faGear} width={16} />}
            >
              Recalculer
            </ColumnButton>
          </CustomTooltip>
        </Stack>

      <CustomTabs
        type={TableType.FuelFee}
        tabs={tabs}
        activeTab={activeTab}
        handleTabChange={handleTabChange}
        handleTabClose={handleTabClose}
      />
      <ConditionalComponent isValid={activeTab === 'list'}
        defaultComponent={
          <FuelFeeForm
            fuelFee={activeTabData?.content as IFuelFee}
            mode={activeTabData?.mode || 'view'}
            onSave={handleSave}
            onClose={() => handleCancel(activeTab)}
            onEdit={handleEdit}
            tableHead={tableHead}
            setHasUnsavedChanges={(value) => setTabHasUnsavedChanges(activeTab, value)}
            updateTabContent={updateTabContent}
            tabId={activeTab}
          />
        }>

        <TableManager
          filteredData={filteredData}
          table={table}
          tableHead={tableHead}
          notFound={notFound}
          filters={filters}
          onFilterChange={handleFilterChange}
          renderRow={renderRow}
        />
      </ConditionalComponent>
      <UnsavedChangesDialog
        open={showConfirmDialog}
        onClose={() => setShowConfirmDialog(false)}
        onConfirm={() => handleConfirmDialogAction()}
        onCancel={() => setShowConfirmDialog(false)}
      />
    </Box>
  );
}
