"use client"

import React, { useEffect } from "react"
import { Grid } from "@mui/material"
import { useFormik } from "formik"
import FormField from "@/shared/components/form/form-field"
import { TableType, type FormFieldType, type ModeType, type TableColumn } from "@/shared/types/common"
import EditExportButtons from "@/shared/components/form/edit-export-buttons"
import ActionButtons from "@/shared/components/form/buttons-action"
import type { IFuelFee } from "@/shared/types/flottes/fuelFee"
import { fuelFeeFormFields } from "../utils/form-fields-fuel-fee"
import FormContainer from "@/layouts/form/form-container"
import { fuelFeeSchema } from "../utils/fuel-fee-schema"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

interface FuelFeeFormProps {
  fuelFee: IFuelFee
  mode: ModeType
  onSave: (updatedFuelFee: IFuelFee) => void
  onEdit: (updatedFuelFee: IFuelFee) => void
  onClose: () => void
  tableHead: TableColumn[]
  setHasUnsavedChanges?: (value: boolean) => void
  updateTabContent?: (tabId: string, newContent: IFuelFee) => void
  tabId?: string
}

export default function FuelFeeForm({ fuelFee, mode, onSave, onClose, onEdit, tableHead,   setHasUnsavedChanges,
  updateTabContent,
  tabId, }: FuelFeeFormProps) {
  const isReadOnly = mode === "view"

  const formik = useFormik<IFuelFee>({
    initialValues: fuelFee,
    validationSchema: fuelFeeSchema,
    onSubmit: (values) => {
      onSave(values);
      if (setHasUnsavedChanges) setHasUnsavedChanges(false)
      onClose();
    },
  });

  useEffect(() => {
    if (updateTabContent && tabId && (mode !== "view")) {
      updateTabContent(tabId, formik.values)
    }
  }, [formik.values, updateTabContent, tabId, mode])


  const renderField = (field: FormFieldType<IFuelFee>) => (
    <FormField
      field={field}
      value={formik.values[field.name as keyof IFuelFee]}
      onChange={(name, value) => formik.setFieldValue(name, value)}
      error={
        formik.touched[field.name as keyof IFuelFee]
          ? (formik.errors[field.name as keyof IFuelFee] as string | undefined)
          : undefined
      }
      onBlur={formik.handleBlur}
      isReadOnly={isReadOnly}
    />
  )

  return (
    <FormContainer titre="Frais Carburant">
           <ConditionalComponent isValid={isReadOnly}>
        <EditExportButtons
          onEdit={() => onEdit(formik.values)}
          onExport={() => void 0}
          tooltipTitle={TableType.FuelFee}
          dataRow={formik.values}
          tableHead={tableHead}
        />
      </ConditionalComponent>
      <form onSubmit={formik.handleSubmit}>
        <Grid container spacing={5}>
          {fuelFeeFormFields.map((field) => (
            <Grid item xs={12} sm={4} key={field.name}>
              {renderField(field)}
            </Grid>
          ))}
              <ConditionalComponent isValid={!isReadOnly}>
            <Grid item xs={12}>
              <ActionButtons
                onSave={() => {
                  formik.validateForm().then((errors) => {
                    formik.submitForm()
                  })
                }}
                onCancel={onClose}
                mode={mode}
              />
            </Grid>
          </ConditionalComponent>
    
        </Grid>
      </form>
    </FormContainer>
  )
}
