'use client';

import React from 'react';
import { Box, IconButton, Stack, Typography } from '@mui/material';
import { TableType } from '@/shared/types/common';
import TableManager from '@/shared/components/table/table-manager';
import { IFuelHistory } from '@/shared/types/flottes/fuelImport';
import FuelFeeTableRow from './fuel-card-row-view';
import { useFuelHistoryTable } from '../hooks/use-fuel-history-table';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';
import FontAwesome from '@/shared/components/fontawesome';
import { faRotate } from '@fortawesome/free-solid-svg-icons';
import { iconButtonStyles } from '@/shared/theme/css';
import ExportButton from '@/shared/components/table/table-export-button';
import { pxToRem } from '@/shared/theme/typography';

export default function FuelFeeListView() {
  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    handleSave,
    dataToExport,
  } = useFuelHistoryTable();

  const renderRow = (row: IFuelHistory) => (
    <FuelFeeTableRow
      key={row.id}
      row={row}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
    />
  );

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        mt:1
      }}
    >
      <Typography
        sx={{
          fontSize: pxToRem(22),
          color: 'primary.main',
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {'Historique Carte carburant'}
      </Typography>
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <Stack direction="row" alignItems="center" justifyContent="flex-end" gap="8px" pb={2}>
          <CustomTooltip title="Refresh" arrow>
            <IconButton onClick={handleResetFilters} sx={iconButtonStyles}>
              <FontAwesome icon={faRotate} width={16} />
            </IconButton>
          </CustomTooltip>
          <ExportButton
            tooltipTitle={'Exporter'}
            type={TableType.FuelHistory}
            filteredData={dataToExport}
            tableHead={tableHead}
          />
        </Stack>
      </Stack>

      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={handleFilterChange}
        renderRow={renderRow}
        sx={{ backgroundColor: 'primary.lighter' }}
        fixedHeight={ `calc(100vh - 420px)`}
        isWithoutTabs
      />
    </Box>
  );
}
