import { TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { INITIAL_AFFECTATION_DATA } from "@/shared/_mock/flottes/_affectation"
import { IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation"

const affectationConfig: TabConfig<IVehicleAffectation> = {
  type: "affectation",
  listTitle: "Liste des affectations",
  newItemTitle: "Nouvelle affectation",
  initialData: INITIAL_AFFECTATION_DATA,
  getItemCode: (affectation) => affectation.marque,
}

export function useAffectationTabs() {
  return useTabsManager<IVehicleAffectation>(affectationConfig)
}

