import { _MODELES, IMMATRICULATIONS } from "@/shared/_mock";
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver";
import { FormFieldType } from "@/shared/types/common";
import { AFFECTATION_OPTION_STATUT, IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation";
import { faNoteSticky } from "@fortawesome/free-solid-svg-icons";
import { _MARQUES } from '../../../../_mock';

export const affectationformFields: FormFieldType<IVehicleAffectation>[] = [
  {
    name: "marque",
    label: "Marque",
    type: "combobox",
    required: true,
    options: _MARQUES.map((marque) => ({ value: marque, label: marque })),
    placeholder: "Choisissez une marque",
  },
  {
    name: "modele",
    label: "Modèle",
    type: "combobox",
    options: _MODELES.map((modele) => ({ value: modele, label: modele })),
    required: true,
  },
  {
    name: "numeroImmatriculation",
    label: "Immatriculation",
    type: "combobox",
    required: true,
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Choisissez une véhicule",
  },
  {
    name: "chauffeur",
    label: "Chauffeur",
    type: "combobox",
    required: true,
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })),
    placeholder: "Choisissez un chauffeur",
  },
  {
    name: "dateAffectation",
    label: "Date d'affectation",
    type: "date",
    required: true,
  },
  {
    name: "dateRetour",
    label: "Date de retour",
    type: "date",
    required: false,
  },
  {
    name: "statut",
    label: "Statut",
    type: "select",
    required: true,
    options: AFFECTATION_OPTION_STATUT,
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
]