"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import SvgColor from "@/shared/components/svg-color"
import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { Consumption } from "@/shared/types/flottes/consumption"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

interface FuelConsumptionTableRowProps {
  row: Consumption
  selected: boolean
  onSelectRow: () => void
  onRowDoubleClick: () => void
  columns: TableColumn[]
  dense: boolean
}

export default function TreatedConsumptionTableRow({
  row,
  selected,
  onSelectRow,
  onRowDoubleClick,
  columns,
  dense,
}: FuelConsumptionTableRowProps) {

  const renderCellContent = (column: TableColumn) => {
    switch (column.id) {
      case "firstName":
        return row.employe.firstName
      case "lastName":
        return row.employe.firstName
      case "vehicule":
        return row.employe.carRegistration || row.employe.vehicule
      case "tanker":
        return row.tanker
      case "department":
        return row.employe.department
      case "date":
        return row.date
      case "phone":
        return row.employe.phone
      case "totalAmount":
        return "0 €"
      case "fuelVolume":
        return '0 L'
      case "circuit":
        return `${row.employe.circuit}`
      default:
        return ""
    }
  }
  return (
    <>
      <ContratStyledRow hover style={{ cursor: "pointer" }}>
       

        {columns.map((column: any, index: number) => (
          <TableCell
            onDoubleClick={onRowDoubleClick}
            key={column.id}
            align={column.align}
            sx={{ whiteSpace: "nowrap", py: dense ? 1 : 2, ...(index === 0 && {position: "relative"}), }}
          >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
                src="/assets/icons/ic_border.svg"
                sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.product) }}
              />
            </ConditionalComponent>
          {renderCellContent(column)}
          </TableCell>
        ))}
      </ContratStyledRow>
    </>
  )
}

