'use client';

import type React from 'react';
import { useState } from 'react';
import { Box, Tabs, Tab } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import { useBoolean } from '@/hooks';
import { ScrollBox, StyledFilterTabs } from '@/shared/theme/css';
import type { Consumption } from '@/shared/types/flottes/consumption';
import TreatedConsumptionTable from '../components/traeted-consumption-table';
import TreatedMileageTable from '../components/mileage/treated-mileage-list-view';
import TreatedConsumptionDrawer from '../components/traeted-consumption-details';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';

const DRAWER_WIDTH = 450;

export default function TraetedAnomaliesView() {
  const openDrawer = useBoolean();
  const [activeTab, setActiveTab] = useState(0);

  const handleTabChange = (event: React.SyntheticEvent, newValue: number) => {
    setActiveTab(newValue);
    openDrawer.onFalse();
  };

  return (
    <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        width: openDrawer.value ? `calc(100% - ${DRAWER_WIDTH}px)` : undefined,
      }}
    >
      <StyledFilterTabs
        sx={{ mb: 2 }}
        value={activeTab}
        onChange={handleTabChange}
        aria-label="anomalies tabs"
      >
        <Tab label="Kilométrage" />
        <Tab label="Consommation" />
      </StyledFilterTabs>

      <ConditionalComponent isValid={activeTab === 0}>
        <TreatedMileageTable openDrawer={openDrawer} />
      </ConditionalComponent>

      <ConditionalComponent isValid={activeTab === 1}>
        <TreatedConsumptionTable openDrawer={openDrawer} />
      </ConditionalComponent>
    </Box>
  );
}
