"use client"
import { Box, Stack, Tabs, Typography } from "@mui/material"
import TableControlBar from "@/shared/components/table/table-control-bar"
import { TableType } from "@/shared/types/common"
import TableManager from "@/shared/components/table/table-manager"
import { TableConfig, useTableManager } from "@/hooks/use-table-manager"
import AllConsumptionsTableRow from "./all-consumptions-table-row"
import { Consumption } from "@/shared/types/flottes/consumption"
import { _consumptionMockList, ALL_CONSUMPTIONS_TABLE_HEAD } from "@/shared/_mock/flottes/_employee"
import { StyledTab, tabsStyles } from "@/shared/theme/css"

const allConsumptionsConfig: TableConfig<Consumption> = {
  initialData: _consumptionMockList,
  defaultTableHead: ALL_CONSUMPTIONS_TABLE_HEAD,
};

export default function AllConsumptionTable() {

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    dataToExport,
    handleColumnsChange,
  } = useTableManager<Consumption>(allConsumptionsConfig);

  const renderRow = (row: Consumption) => (
    <AllConsumptionsTableRow
      key={row.id}
      row={row}
      onRowDoubleClick={() => void 0}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
      dense={table.dense}
    />
  )

  return (
    <Box>
        <Typography
        variant="h5"
        sx={{
            color: 'primary.main',
            fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
        >
        Toutes les consommations
        </Typography>
      <Stack flexGrow={0} direction="row" alignItems="center" justifyContent="flex-end" spacing={{ xs: 0.5, sm: 1 }}>
        <TableControlBar
          type={TableType.Consumption}
          activeTab={'list'}
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
                 />
      </Stack>

      <Tabs value={'list'} sx={tabsStyles}>
        <StyledTab value={'list'} label={'Liste de toutes les consommations'} />
      </Tabs>

      <TableManager
        filteredData={filteredData}
        table={table}
        tableHead={tableHead}
        notFound={notFound}
        filters={filters}
        onFilterChange={handleFilterChange}
        renderRow={renderRow}
        fixedHeight="calc(100vh - 380px)"
      />
    </Box>
  )
}

