'use client';

import React, { useState } from 'react';
import { Box, Tab } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import PieCharts from '@/shared/components/charts/pie-charts';
import { useBoolean } from '@/hooks';
import { ScrollBox, StyledFilterTabs } from '@/shared/theme/css';
import { _mileageList } from '@/shared/_mock/flottes/_mileage';
import { Consumption } from '@/shared/types/flottes/consumption';
import AbnormalConsumptionTable from '../components/abnormal-consumption-table';
import AbnormalConsumptionDrawer from '../components/abnormal-consumption-details';
import AllConsumptionTable from '../components/allConsumptions/all-consumption-table';
import ConditionalComponent from '@/shared/components/table/ConditionalComponent';
const charts = [
  {
    title: 'Consommation carburant Total',
    data: [
      { id: 'Anormale', value: 10, label: 'Anormale', color: '#FF3434' },
      { id: 'Normale', value: 15, label: 'Normale', color: '#36B37E' },
    ],
  },
  {
    title: 'Consommation carburant DKV',
    data: [
      { id: 'Anormale', value: 10, label: 'Anormale', color: '#FF3434' },
      { id: 'Normale', value: 52, label: 'Normale', color: '#36B37E' },
    ],
  },
];
const DRAWER_WIDTH = 450;

export default function CarburantListView() {
  const openDrawer = useBoolean();
  const [activeTab, setActiveTab] = useState(0);

  const handleTabChange = (event: React.SyntheticEvent, newValue: number) => {
    setActiveTab(newValue);
    openDrawer.onFalse();
  };
  return (
    <ScrollBox
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 20}px)`,
        width: openDrawer.value ? `calc(100% - ${DRAWER_WIDTH}px)` : undefined,
      }}
    >
      <Box>
        <PieCharts charts={charts} />
      </Box>

      <StyledFilterTabs
        sx={{ mb: 2 }}
        value={activeTab}
        onChange={handleTabChange}
        aria-label="anomalies tabs"
      >
        <Tab label="Anormale" />
        <Tab label="Toutes" />
      </StyledFilterTabs>

      <ConditionalComponent isValid={activeTab === 0}>
        <AbnormalConsumptionTable openDrawer={openDrawer} />
      </ConditionalComponent>

      <ConditionalComponent isValid={activeTab === 1}>
        <AllConsumptionTable />
      </ConditionalComponent>
    </ScrollBox>
  );
}
