'use client';

import React, { useState } from 'react';
import Button from '@mui/material/Button';
import Typography from '@mui/material/Typography';
import {
  List,
  ListItem,
  ListItemIcon,
  ListItemText,
  Divider,
  RadioGroup,
  Checkbox,
} from '@mui/material';
import Radio from '@mui/material/Radio';
import FormControlLabel from '@mui/material/FormControlLabel';
import FormControl from '@mui/material/FormControl';
import Box from '@mui/material/Box';
import { format } from 'date-fns';
import FontAwesome from '@/shared/components/fontawesome';
import {
  faCalendarDays,
  faCar,
  faLocationDot,
  faMapPin,
  faCircleExclamation,
} from '@fortawesome/free-solid-svg-icons';
import type { IGeolocData } from '@/shared/types/flottes/mileage';
import { StyledTextField } from '@/shared/theme/css';
import SvgColor from '@/shared/components/svg-color';

type Props = {
  open: boolean;
  onClose: () => void;
  geolocData: IGeolocData;
  carRegistration: string;
  lastTanker: string;
};
export default function MileageDetails({
  open,
  onClose,
  geolocData,
  carRegistration,
  lastTanker,
}: Props) {
  const [value, setValue] = React.useState('non_justifié');
  const [sendMail, setSendMail] = useState(false);
  const [description, setDescription] = useState('');

  const handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setValue((event.target as HTMLInputElement).value);
  };

  const handleClose = () => {
    onClose();
  };

  const handleCheckboxChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    setSendMail(event.target.checked);
  };

  const handleSendMessage = (event: React.FormEvent<HTMLFormElement>) => {
    event.preventDefault();
    console.log('Message sent');
    if (sendMail) {
      console.log('Mail sent');
    }
    handleClose();
  };

  const handleDescriptionChange = (event: React.ChangeEvent<HTMLTextAreaElement>) => {
    setDescription(event.target.value);
  };

  return (
    <>
      <Box sx={{ p: 1 }}>
        <Divider />
        <List>
          <ListItem>
            <ListItemIcon sx={{ color: 'primary.main' }}>
              <FontAwesome icon={faCalendarDays} width={18} />
            </ListItemIcon>
            <ListItemText
              primary={
                <Box component="span" display="flex" alignItems="center">
                  <Typography component="span" sx={{ fontWeight: 'bold' }}>
                    Date:&nbsp;
                  </Typography>
                  <Typography component="span">
                    {format(new Date(geolocData.departureDate), 'dd/MM/yyyy HH:mm')} -{' '}
                    {format(new Date(geolocData.arrivalDate), 'dd/MM/yyyy HH:mm')}
                  </Typography>
                </Box>
              }
            />
          </ListItem>

          <ListItem>
            <ListItemIcon sx={{ color: 'primary.main' }}>
              <SvgColor
                src="/assets/icons/menu/ic_exploitation.svg"
                sx={{ color: 'primary.main', width: 18, height: 18 }}
              />
            </ListItemIcon>
            <ListItemText
              primary={
                <Box component="span" display="flex" alignItems="center">
                  <Typography component="span" sx={{ fontWeight: 'bold' }}>
                    Distance:&nbsp;
                  </Typography>
                  <Typography component="span">{geolocData.distance} KM</Typography>
                </Box>
              }
            />
          </ListItem>


          <ListItem>
            <ListItemIcon sx={{ color: 'primary.main' }}>
              <FontAwesome icon={faCar} width={18} />
            </ListItemIcon>
            <ListItemText
              primary={
                <Box component="span" display="flex" alignItems="center">
                  <Typography component="span" sx={{ fontWeight: 'bold' }}>
                    Véhicule:&nbsp;
                  </Typography>
                  <Typography component="span">
                    {carRegistration + '(' + lastTanker + ')'}
                  </Typography>
                </Box>
              }
            />
          </ListItem>

          <ListItem>
            <ListItemIcon sx={{ color: 'primary.main' }}>
              <FontAwesome icon={faLocationDot} width={18} />
            </ListItemIcon>
            <ListItemText
              primary={
                <Box component="span" display="flex" alignItems="center">
                  <Typography component="span" sx={{ fontWeight: 'bold' }}>
                    Adresse de départ:&nbsp;
                  </Typography>
                  <Typography component="span">{geolocData.departureLocation}</Typography>
                </Box>
              }
            />
          </ListItem>

          <ListItem>
            <ListItemIcon sx={{ color: 'primary.main' }}>
              <FontAwesome icon={faMapPin} width={18} />
            </ListItemIcon>
            <ListItemText
              primary={
                <Box component="span" display="flex" alignItems="center">
                  <Typography component="span" sx={{ fontWeight: 'bold' }}>
                    Adresse d&apos;arrivée:&nbsp;
                  </Typography>
                  <Typography component="span">{geolocData.arrivalLocation}</Typography>
                </Box>
              }
            />
          </ListItem>
          <Divider variant="inset" component="li" />

          <ListItem>
            <ListItemIcon>
              <FontAwesome icon={faCircleExclamation} width={18} sx={{ color: 'error.main' }} />
            </ListItemIcon>
            <ListItemText
              primary={
                <Typography variant="subtitle2" sx={{ color: 'red' }}>
                  {geolocData.causes}
                </Typography>
              }
            />
          </ListItem>
          <Divider variant="inset" component="li" />
          <Box sx={{ mt: 2 }}>
            <FormControl>
              <RadioGroup
                aria-labelledby="demo-controlled-radio-buttons-group"
                name="controlled-radio-buttons-group"
                value={value}
                onChange={handleChange}
                row
              >
                <FormControlLabel value="justifié" control={<Radio />} label="Justifié" />
                <FormControlLabel value="non_justifié" control={<Radio />} label="Non justifié" />
              </RadioGroup>
            </FormControl>

            <Box
              component="form"
              onSubmit={handleSendMessage}
              noValidate
              autoComplete="off"
              sx={{
                mt: 2,
                display: 'flex',
                flexDirection: 'column',
              }}
            >
              <StyledTextField
                autoFocus
                margin="dense"
                id="description"
                label="Observation"
                multiline
                rows={3}
                fullWidth
                onChange={handleDescriptionChange}
                variant="outlined"
                required
              />
              <FormControlLabel
                control={<Checkbox checked={sendMail} onChange={handleCheckboxChange} />}
                label="Envoyer un mail"
              />
              <Box sx={{ mt: 1, display: 'flex', justifyContent: 'flex-end' }}>
                <Button type="submit" variant="contained" color="primary">
                  Envoyer
                </Button>
              </Box>
            </Box>
          </Box>
        </List>
      </Box>
    </>
  );
}
