'use client';

import { IconButton, Typography } from '@mui/material';
import MileageDetails from './mileage-details';
import type { IGeolocData, IMileage } from '@/shared/types/flottes/mileage';
import FontAwesome from '@/shared/components/fontawesome';
import { faClose } from '@fortawesome/free-solid-svg-icons';
import { ScrollBox } from '@/shared/theme/css';
import CustomDrawer from '@/shared/components/drawer/custom-drawer';
import { useEffect } from 'react';
import { mockedGeolocData } from '@/shared/_mock/flottes/_mileage';

const DRAWER_WIDTH = 500;

type Props = {
  isOpen: any;
  onClose: () => void;
  rowData: IMileage;
};

export default function MileageDrawer({ isOpen, onClose, rowData }: Props) {

  return (
    <CustomDrawer drawerWidth={DRAWER_WIDTH} open={isOpen.value} onClose={onClose}>
      <Typography
        variant="h5"
        sx={{
          p: 2,
          color:"primary.main",
          fontWeight: (theme) => theme.typography.fontWeightBold,
        }}
      >
        {rowData.firstname} {rowData.lastname}
      </Typography>

      <ScrollBox sx={{ maxHeight: 'calc(100vh - 80px)'}}>
        <MileageDetails
          geolocData={mockedGeolocData}
          onClose={onClose}
          open={isOpen.value}
          carRegistration={rowData.car || ''}
          lastTanker={rowData.petrolier || ''}
        />

      </ScrollBox>
    </CustomDrawer>
  );
}
