'use client';

import React, { useState } from 'react';
import { Box, Stack, Tabs } from '@mui/material';
import { HEADER } from '@/layouts/config-layout';
import TableControlBar from '@/shared/components/table/table-control-bar';
import { useMileageTable } from '../hooks/use-mileage-table';
import { TableType } from '@/shared/types/common';
import { IMileage } from '@/shared/types/flottes/mileage';
import TableManager from '@/shared/components/table/table-manager';
import MileageTableRow from './mileage-table-row';
import PieCharts from '@/shared/components/charts/pie-charts';
import { useBoolean } from '@/hooks';
import MileageDrawer from '../components/mileage-dialog';
import { StyledTab, tabsStyles } from '@/shared/theme/css';
const charts = [
  {
    title: 'Utilisation anormale des véhicules professionnels',
    data: [
      { id: 'Anormale', value: 10, label: 'Anormale', color: '#FF3434' },
      { id: 'Normale', value: 15, label: 'Normale', color: '#36B37E' },
    ],
  },
];
const DRAWER_WIDTH = 500;

export default function MileageListView() {
  const openDrawer = useBoolean()
  const [selectedRowForDrawer, setSelectedRowForDrawer] = useState<IMileage | null>(null)

  const {
    table,
    filteredData,
    filters,
    tableHead,
    notFound,
    handleFilterChange,
    handleResetFilters,
    handleResetColumns,
    handleColumnsChange,
    dataToExport,
  } = useMileageTable();

  const handleRowDoubleClick = (row: IMileage) => {
    setSelectedRowForDrawer(row)
    openDrawer.onTrue()
  }

  const renderRow = (row: IMileage) => (
    <MileageTableRow
      key={row.id}
      row={row}
      onRowDoubleClick={() => handleRowDoubleClick(row)}
      selected={table.selected.includes(row.id)}
      onSelectRow={() => table.onSelectRow(row.id)}
      columns={tableHead}
      dense={table.dense}
    />
  )
  
  return (
   <Box
      sx={{
        display: 'flex',
        flexDirection: 'column',
        height: `calc(100vh - ${HEADER.H_DESKTOP + 8}px)`,
        width: openDrawer.value ? `calc(100% - ${DRAWER_WIDTH}px)` : undefined,
      }}
    >
      <Box >
      <PieCharts charts={charts} />
      </Box>
      
      <Stack
        flexGrow={0}
        direction="row"
        alignItems="center"
        justifyContent="flex-end"
        spacing={{ xs: 0.5, sm: 1 }}
      >
        <TableControlBar
          type={TableType.Mileage}
          activeTab="list"
          onResetFilters={handleResetFilters}
          onResetColumns={handleResetColumns}
          onColumnsChange={handleColumnsChange}
          initialColumns={tableHead}
          onFilters={handleFilterChange}
          filteredData={dataToExport}
            />
      </Stack>

      <Tabs value={'list'} sx={tabsStyles}>
        <StyledTab value={'list'} 
          label={'Liste des conducteurs ayant utilisé leur véhicule hors horaires de travail'} />
      </Tabs>

        <TableManager
            filteredData={filteredData}
            table={table}
            tableHead={tableHead}
            notFound={notFound}
            filters={filters}
            onFilterChange={handleFilterChange}
            renderRow={renderRow}
            fixedHeight="calc(100vh - 340px)"
          />
        
      {selectedRowForDrawer ? (
        <MileageDrawer isOpen={openDrawer} onClose={openDrawer.onFalse} rowData={selectedRowForDrawer} />
      ):<></>}
    </Box>
  );
}