import { TableConfig, useTableManager } from '@/hooks/use-table-manager';
import { IIntervention } from '@/shared/types/flottes/intervention';
import { _interventions, DEFAULT_INTERVENTION_TABLE_HEAD } from '@/shared/_mock/flottes/_intervention';

const interventionConfig: TableConfig<IIntervention> = {
  initialData: _interventions,
  defaultTableHead: DEFAULT_INTERVENTION_TABLE_HEAD,
};

export function useInterventionTable() {
  return useTableManager<IIntervention>(interventionConfig);
}