import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_INTERVENTION_DATA } from '@/shared/_mock/flottes/_intervention';
import { IIntervention } from '@/shared/types/flottes/intervention';

const iInterventionConfig: TabConfig<IIntervention> = {
  type: 'Réparation',
  listTitle: 'Entretien / Réparation',
  newItemTitle: 'Nouvelle Réparation',
  initialData: INITIAL_INTERVENTION_DATA,
  getItemCode: (inter) => inter.vehiculeConcerne,
};

export function useInterventionTabs() {
  return useTabsManager<IIntervention>(iInterventionConfig);
}

