import type { IIntervention } from "@/shared/types/flottes/intervention"
import type { FormFieldType } from "@/shared/types/common"
import {
  faHashtag,
  faNoteSticky,
  faTachometerAltAverage,
  faEuro,
} from "@fortawesome/free-solid-svg-icons"
import { _OPTION_STATUT, _TYPES_INTERVENTION } from "@/shared/_mock/flottes/_intervention"
import { _BINARY_Qst } from "@/shared/_mock/_trajets"

export const interventionformFields: FormFieldType<IIntervention>[] = [
  {
    name: "vehiculeConcerne",
    label: "Véhicule concerné",
    type: "select",
    placeholder: "Choisissez une véhicule",
  },
  {
    name: "typeIntervention",
    label: "Type de Réparation",
    type: "select",
    placeholder: "Sélectionnez un type",
    options: _TYPES_INTERVENTION.map((type) => ({ value: type, label: type })),
  },
  {
    name: "dateIntervention",
    label: "Date de Réparation",
    type: "date",
  },
  {
    name: "statut",
    label: "Statut",
    type: "select",
    placeholder: "Sélectionnez un statut",
    options: _OPTION_STATUT,
  },
  {
    name: "kilometrageReleve",
    label: "Kilométrage relevé",
    type: "text",
    placeholder: "Entrez le kilométrage",
    icon: faTachometerAltAverage,
  },
  {
    name: "montantDevis",
    label: "Devis",
    type: "text",
    placeholder: "Entrez ou choisissez un montant",
    icon: faEuro,
  },
  {
    name: "coutTTC",
    label: "Coût TTC",
    type: "text",
    placeholder: "Entrez le coût TTC",
    icon: faHashtag,
  },
  {
    name: "coutHT",
    label: "Coût HT",
    type: "text",
    placeholder: "Entrez le coût HT",
    icon: faHashtag,
  },
  {
    name: "acceptationDevis",
    label: "Accepté",
    type: "select",
    options: _BINARY_Qst,
  },
  {
    name: "client",
    label: "Client",
    type: "select",
    placeholder: "Choisissez un nom",
  },
  {
    name: "societe",
    label: "Société",
    type: "select",
    placeholder: "Choisissez une société",
  },
  {
    name: "reparateur",
    label: "Réparateur",
    type: "select",
    placeholder: "Choisissez un réparateur",
  },
  {
    name: "fournisseur",
    label: "Fournisseur",
    type: "select",
    placeholder: "Choisissez un fournisseur",
  },
  {
    name: "dateDebutImmobilisation",
    label: "début immobilisation",
    type: "date",
  },
  {
    name: "dateFinImmobilisation",
    label: "fin immobilisation",
    type: "date",
  },
  {
    name: "garantie",
    label: "Sous Garantie",
    type: "select",
    options: _BINARY_Qst,
  },
  {
    name: "factureRecue",
    label: "Facture",
    type: "select",
    options: _BINARY_Qst,
  },
  {
    name: "conducteurPrevenu",
    label: "Conducteur",
    type: "select",
    options: _BINARY_Qst,
  },
  {
    name: "le",
    label: "Le",
    type: "date",
  },
  {
    name: "observations",
    label: "Observation libre",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },

]

