import { IIncident } from '@/shared/types/flottes/incident';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';
import { INITIAL_INCIDENT_DATA } from '@/shared/_mock/flottes/_Incidents';

const incidentConfig: TabConfig<IIncident> = {
  type: 'sinistre',
  listTitle: 'incidents / Sinistre',
  newItemTitle: 'Nouveau Sinistre',
  initialData: INITIAL_INCIDENT_DATA,
  getItemCode: (incident) => incident.typeSinistre,
};

export function useIncidentTabs() {
  return useTabsManager<IIncident>(incidentConfig);
}