import * as yup from 'yup'
import { _TYPES_SINISTRES } from '@/shared/_mock/flottes/_Incidents'

export const incidentSchema = yup.object().shape({
  driver: yup.string().required('Le chauffeur est requis'),
  vehicule: yup.string().required('Le véhicule est requis'),
  dateSinistre: yup.date().required('La date du sinistre est requise'),
  typeSinistre: yup.string()
    .oneOf(Object.values(_TYPES_SINISTRES), 'Type de sinistre invalide')
    .required('Le type de sinistre est requis'),
  statut: yup.string().required('Le statut est requis'),
  observation: yup.string(),
  constat: yup.string(),
  envoiDeclaration: yup.string(),
  dateDeclaration: yup.date().required('La date de déclaration est requise'),
  dateCloture: yup.date(),
  montantFranchise: yup.number(),
  numeroDossier: yup.string(),
}) 