import { IVehicle } from '@/shared/types/flottes/vehicule';
import { INITIAL_VEHICLE_DATA } from '@/shared/_mock/flottes/_vehicle';
import { TabConfig, useTabsManager } from '@/hooks/use-tabs-manager';

const vehicleConfig: TabConfig<IVehicle> = {
  type: 'véhicule',
  listTitle: 'Liste des véhicules',
  newItemTitle: 'Nouveau véhicule',
  initialData: INITIAL_VEHICLE_DATA,
  getItemCode: (vehicle) => vehicle.marque,
};

export function useVehicleTabs() {
  return useTabsManager<IVehicle>(vehicleConfig);
}

