import type { ITypeIncident } from "@/shared/types/flottes/incident"
import { INITIAL_TYPE_INCIDENT_DATA } from "@/shared/_mock/flottes/_Incidents"
import { type TabConfig, useTabsManager } from "@/hooks/use-tabs-manager"
import { _TypesIncidents } from "@/shared/_mock/flottes/_Incidents"

const incidentTypeTabConfig: TabConfig<ITypeIncident> = {
  type: "type d'incident",
  listTitle: "Liste des types d'incidents",
  newItemTitle: "Nouveau type d'incident",
  initialData: INITIAL_TYPE_INCIDENT_DATA,
  getItemCode: (incidentType) => incidentType.intitule,
}

export function useIncidentTypeTabs() {
  return useTabsManager<ITypeIncident>(incidentTypeTabConfig)
}
