import type { FormFieldType } from "@/shared/types/common"
import { IVehicleModel } from "@/shared/types/flottes/vehicule"
import { faNoteSticky, faCalendarCheck } from "@fortawesome/free-solid-svg-icons"

export const vehicleModelFormFields: FormFieldType<IVehicleModel>[] = [
  {
    name: "marque",
    label: "Marque",
    type: "combobox",
    required: true,
    placeholder: "Choisissez une marque",
  },
  {
    name: "modele",
    label: "Modèle",
    type: "combobox",
    required: true,
    placeholder: "Choisissez un modèle",
  },
  {
    name: "dateEntretien",
    label: "Date d'entretien générales",
    type: "date",
    icon: faCalendarCheck,
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky
  },
]
