"use client"
import Checkbox from "@mui/material/Checkbox"
import TableCell from "@mui/material/TableCell"
import Switch from "@mui/material/Switch"

import TableActionColumn from "@/shared/components/table/table-action-column"
import SvgColor from "@/shared/components/svg-color"

import type { TableColumn } from "@/shared/types/common"
import { ContratStyledRow, getStatusColor } from "@/shared/sections/contract/styles"
import { IVehicleModel } from "@/shared/types/flottes/vehicule"
import ConditionalComponent from "@/shared/components/table/ConditionalComponent"

type Props = {
  handleEditVehicleModel: (vehicleModel: IVehicleModel) => void
  handleDetailsVehicleModel: (vehicleModel: IVehicleModel) => void
  selected: boolean
  row: IVehicleModel
  onSelectRow: VoidFunction
  columns: TableColumn[]
}

const TOOLTIP_TITLES = {
  edit: "Modifier modèle",
  duplicate: "Copier modèle",
  active: "Modèle actif",
  inactive: "Modèle inactif",
}

export default function VehicleModelTableRow({
  row,
  handleEditVehicleModel,
  handleDetailsVehicleModel,
  selected,
  onSelectRow,
  columns,
}: Props) {
  const renderCellContent = (columnId: string, value: any) => {
    switch (columnId) {
      default:
        return value
    }
  }

  return (
    <ContratStyledRow hover style={{ cursor: "pointer" }}>

      {columns.filter((column) => column.id !== 'isActive')
        .map((column: any, index: number) => (
        <TableCell
          onDoubleClick={() => handleDetailsVehicleModel(row)}
          key={column.id}
          align={column.align}
          sx={{ whiteSpace: "nowrap", py: column.id === "isActive" ? 0 : "inherit", ...(index === 0 && {position: "relative"}), }}
        >
            <ConditionalComponent isValid={index === 0}>
            <SvgColor
              src="/assets/icons/ic_border.svg"
              sx={{ position: "absolute", top: 0, left: -4, height: "100%", color: getStatusColor(row.id) }}
            />
            </ConditionalComponent>
          {renderCellContent(column.id, row[column.id as keyof IVehicleModel])}
        </TableCell>
      ))}

      <TableCell align="right" sx={{ px: 1, whiteSpace: "nowrap" }}>
        <TableActionColumn
          handleEdit={() => handleEditVehicleModel(row)}
          onToggle={(checked) => void 0}
          isActive={row.isActive}
          tooltipTitles={TOOLTIP_TITLES}
        />
      </TableCell>
    </ContratStyledRow>
  )
}
